#include "extensions.h"
#include "all_max.h"
#include "cliques.h"
#include "graph.h"
#include "jacobi.h"
#include <cmath>
#include <cstdio>
#include <vector>

using namespace std;

symmetric_matrix input_matrix(istream &);
void find_good_vertex(symmetric_matrix &, real, vector<vector<int>> &);
void wait_for(char, istream &, const char *);

void maximal_extensions(CalculatingWindow &w, const char *input_file_name,
                        const char *good_vertex_file_name,
                        const char *egraph_file_name,
                        const char *good_sets_file_name,
                        const char *max_exts_file_name) {
  try {
    QString str;
    //    output << "Calculating maximal extensions\n";
    ifstream input_file(input_file_name);

    str = QString("No input file\"") + input_file_name + "\".";

    if (!input_file)
      throw(str.toStdString());

    ofstream outputfile(good_sets_file_name);

    //  processingthrow("izlazna")

    real lambda;
    unsigned long int i, j, k;
    int l, counter;
    vector<vector<int>> good_vertex;

    symmetric_matrix c_matrix = input_matrix(input_file);
    input_file >> lambda;

    if (!input_file)
      throw(string("Warning: Real number expected!"));

    //    if (fabs(lambda + 1) < EPS || fabs(lambda) < EPS)
    //      throw(string("Warning: The eigenvalue must be distinct from 0 and
    //      -1!"));

    w.print("The star complement spectrum is");

    vector<real> spectrum = c_matrix.spectrum();

    for (i = 0; i < spectrum.size(); i++) {
      CHECK_STOPPING
      str.setNum((double)spectrum[i], 'g', 6);
      w.print(str);
    }

    for (i = 0; i < spectrum.size(); i++) {
      CHECK_STOPPING

      if (fabs(lambda - (spectrum[i])) < EPS)
        throw(string("Warning: The graph spectrum contains given eigenvalue!"));
    }

    find_good_vertex(c_matrix, lambda, good_vertex);

    {
      ofstream good_vertex_file(good_vertex_file_name);

      for (i = 0; i < good_vertex.size(); i++)
        for (j = 0; j < good_vertex[i].size(); j++) {
          CHECK_STOPPING
          good_vertex_file << good_vertex[i][j];

          if (j + 1 < good_vertex[i].size())
            good_vertex_file << " ";
          else
            good_vertex_file << "\n";
        }
    }

    symmetric_matrix ext_matrix(c_matrix.order() + 2);
    symmetric_matrix e_matrix(good_vertex.size());
    symmetric_matrix n_matrix(good_vertex.size());

    for (i = 1; i <= c_matrix.order(); i++)
      for (j = 1; j < i; j++) {
        CHECK_STOPPING
        ext_matrix(i, j) = c_matrix(i, j);
      }

    for (i = 1; i < good_vertex.size(); i++)
      for (j = 0; j < i; j++) {
        for (k = 1; k <= c_matrix.order(); k++) {
          CHECK_STOPPING
          ext_matrix(c_matrix.order() + 1, k) = good_vertex[i][k - 1];
          ext_matrix(c_matrix.order() + 2, k) = good_vertex[j][k - 1];
        }

        for (k = 0; k <= 1; k++) {
          CHECK_STOPPING
          ext_matrix(c_matrix.order() + 1, c_matrix.order() + 2) = k;
          ext_matrix(c_matrix.order() + 2, c_matrix.order() + 1) = k;
          spectrum = ext_matrix.spectrum();
          counter = 0;

          for (l = 0; l < spectrum.size(); l++) {
            CHECK_STOPPING

            if (fabs(spectrum[l] - lambda) < EPS)
              counter++;
          }

          if (counter > 1) {
            e_matrix(i + 1, j + 1) = 1;
            n_matrix(i + 1, j + 1) = k;

            break;
          }
        }
      }

    {
      ofstream egraph_file(egraph_file_name);
      egraph_file << e_matrix;
    } // brackets closes output file

    ifstream egraph_file(egraph_file_name);
    ofstream cliques_file("workspace/extensions/cliques.txt");

    try {
      calculate_cliques(0, egraph_file, cliques_file, false);
    } catch (const string &message) {
      ofstream maxexts_file(max_exts_file_name);

      throw(message);
    }

    double lmbd = lambda;

    if (fabs(lmbd) < EPS) {
      lmbd = 0;
    } else if (fabs(lmbd + 1) < EPS) {
      lmbd = -1;
    }

    all_max(c_matrix, n_matrix, good_vertex, lambda);

    {
      ifstream temp("maxexts.tmp");
      ofstream maxexts_file(max_exts_file_name);

      w.print("Maximal graphs computing...");
      maxexts_file << "The maximal graphs are:";
      calculate_classes(0, temp, maxexts_file, false);
    } // brackets closes input and output files

    remove("maxexts.tmp");

    ifstream maxexts_file(max_exts_file_name);
    ofstream good_sets_file(good_sets_file_name);

    good_sets_file << "The good sets are:\n\n";

    while (true) {
      char c;

      wait_for('\n', maxexts_file, max_exts_file_name);
      maxexts_file >> i;

      if (maxexts_file.eof())
        break;

      good_sets_file << i << "\n\n";
      wait_for('0', maxexts_file, max_exts_file_name);

      unsigned long int order = 1;

      do {
        CHECK_STOPPING
        c = maxexts_file.get();

        if (maxexts_file.eof()) {
          string error_message = "Unexpected end of file \'";

          error_message += max_exts_file_name;
          error_message += "\'";

          string_converter message(error_message);

          throw(message.c_string());
        }

        if (c == '0' || c == '1')
          order++;
      } while (c != '\n');

      for (i = 0; i < c_matrix.order() - 1; i++) {
        CHECK_STOPPING
        wait_for('\n', maxexts_file, max_exts_file_name);
      }

      for (i = 0; i < order - c_matrix.order(); i++) {
        for (j = 0; j < c_matrix.order(); j++) {
          CHECK_STOPPING
          maxexts_file >> k;
          good_sets_file << k;

          if (j < c_matrix.order() - 1)
            good_sets_file << " ";
        }

        good_sets_file << "\n";
        wait_for('\n', maxexts_file, max_exts_file_name);
      }

      good_sets_file << "\n";
      wait_for(']', maxexts_file, max_exts_file_name);
    }

    w.print("Maximal extensions computed!");
  } catch (const string &message) {
    if (message.empty() == false)
      throw(message);
  }
}

void wait_for(char c, istream &istr, const char *filename) {
  char ch;

  do {
    CHECK_STOPPING
    ch = istr.get();

    if (istr.eof()) {
      string error_message = "Unexpected end of file \'";

      error_message += filename;
      error_message += "\'";

      string_converter message(error_message);

      throw(message.cpp_string());
    }
  } while (ch != c);
}

symmetric_matrix input_matrix(istream &istr) {
  vector<int> v;
  char ch;

  do {
    CHECK_STOPPING
    ch = istr.get();

    if (istr.eof())
      break;

    if (ch == '0' || ch == '1') {
      v.push_back(ch - '0');

      continue;
    }

    if (ch == '\n')
      if (v.size() > 0)
        break;
      else
        continue;

    if (ch != '\t' && ch != ' ' && ch != '\n') {
      while (ch != '\n') {
        CHECK_STOPPING
        ch = istr.get();

        if (istr.eof())
          break;
      }
    }
  } while (!istr.eof());

  if (v.size() == 0)
    throw(string("Warning: There is no input matrix!"));

  if (v[0] == 1)
    throw(string("Warning: Illegal entries!"));

  unsigned long int i, j;
  symmetric_matrix m(v.size());

  for (i = 0; i < v.size(); i++) {
    CHECK_STOPPING
    m(1, i + 1) = v[i];
  }

  for (i = 2; i <= v.size(); i++)
    for (j = 1; j <= v.size(); j++) {
      CHECK_STOPPING
      istr >> m(i, j);

      if (istr.eof())
        throw(string("Warning: Illegal entries!"));

      if (i < j) {
        if (m(i, j) != m(j, i))
          throw(string("Warning: Illegal entries!"));
      } else if (i == j) {
        if (m(i, i) != 0)
          throw(string("Warning: Illegal entries!"));
      }
    }

  return m;
}

void find_good_vertex(symmetric_matrix &c_matrix, real lambda,
                      vector<vector<int>> &good_vertex) {
  vector<int> row;
  unsigned long int i, j;

  for (i = 0; i < c_matrix.order(); i++)
    row.push_back(0);

  while (true) {
    for (i = 0; i < row.size(); i++) {
      CHECK_STOPPING

      if (row[i] == 0)
        break;
    }

    if (i >= row.size())
      return;

    row[i] = 1;

    for (j = 0; j < i; j++) {
      CHECK_STOPPING
      row[j] = 0;
    }
    symmetric_matrix ext_matrix(c_matrix.order() + 1);

    for (i = 1; i <= c_matrix.order(); i++)
      for (j = 1; j <= i; j++) {
        CHECK_STOPPING
        ext_matrix(i, j) = c_matrix(i, j);
      }

    for (j = 1; j < i; j++) {
      CHECK_STOPPING
      ext_matrix(i, j) = row[j - 1];
    }

    ext_matrix(i, i) = 0;

    vector<real> spectrum = ext_matrix.spectrum();

    for (i = 0; i < spectrum.size(); i++) {
      CHECK_STOPPING

      if (fabs(lambda - spectrum[i]) < EPS) {
        good_vertex.push_back(row);

        break;
      }
    }
  }
}
